program vect

  implicit none

  integer, parameter  :: n=655360000

  integer :: i, ir, t1, t2

  real(kind=8), allocatable,dimension(:) :: a_vec, b_vec, c_vec, d_vec, e_vec
  !dir$ attributes align:64 ::a_vec,b_vec,c_vec,d_vec,e_vec
  
  real(kind=4) :: temps, t_cpu_0, t_cpu_1, t_cpu

  allocate(a_vec(n),b_vec(n),c_vec(n),d_vec(n),e_vec(n))

  call init(a_vec,b_vec,c_vec,d_vec,e_vec,n)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test0(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test1(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test2(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test3(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test4(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test5(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test6(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test7(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)
  call test8(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)
  call impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)


!  call cpu_time(t_cpu_1,ir)
!  call system_clock(count=t2, count_rate=ir)

!  temps = real(t2-t1,kind=4)/real(ir,kind=4)
!  t_cpu = t_cpu_1-t_cpu_0


  ! Impression du resultat
!  print *, 'Temps CPU / system ', t_cpu, temps,' secs'
  print *, 'n :', n
  print *, 'Norme ||a|| = ', norm2(a_vec)

  deallocate(a_vec,b_vec,c_vec,d_vec,e_vec)


end program vect

subroutine impTemps(t1,t2,t_cpu_0,t_cpu_1,ir)
      real(kind=4) :: temps, t_cpu_0, t_cpu_1, t_cpu
      integer :: t1,t2,ir

      temps = real(t2-t1,kind=4)/real(ir,kind=4)
      t_cpu = t_cpu_1-t_cpu_0

      print *, 'Temps CPU / system ', t_cpu, temps,' secs'
      return
end

subroutine init(a_vec,b_vec,c_vec,d_vec,e_vec,n)
      real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
      integer :: n

        !$omp parallel do schedule(static)
        do i=1,n
            a_vec(i)=0.
            c_vec(i)=sin(2.*i)
            b_vec(i)=cos(3.*i)
            d_vec(i)=sin(4.*i)
            e_vec(i)=cos(5.*i)
        enddo
     
     return
end


! Niveau 0 (2 mult, 1 add, 3 total, 0.075 Flop/B)
subroutine test0(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*c_vec(i) &
            +d_vec(i)*e_vec(i)
  enddo
  return

end

! Niveau 1 (6 mult, 5 add, 11 total, 0.275 Flop/B)
subroutine test1(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*c_vec(i) &
            +b_vec(i)*d_vec(i) &
            +b_vec(i)*e_vec(i) &
            +c_vec(i)*d_vec(i) &
            +c_vec(i)*e_vec(i) &
            +d_vec(i)*e_vec(i)
  enddo
  return

end

! Niveau 1 (10 mult, 9 add, 19 total, 0.475 Flop/B)
subroutine test2(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*b_vec(i) &
            +b_vec(i)*c_vec(i) &
            +b_vec(i)*d_vec(i) &
            +b_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i) &
            +c_vec(i)*d_vec(i) &
            +c_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i) &
            +d_vec(i)*e_vec(i) &
            +e_vec(i)*e_vec(i)
  enddo
  return

end

! Niveau 1 (20 mult, 9 add, 29 total, 0.725 Flop/B)
subroutine test3(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*b_vec(i)*b_vec(i) &
            -b_vec(i)*b_vec(i)*c_vec(i) &
            +b_vec(i)*b_vec(i)*d_vec(i) &
            -b_vec(i)*b_vec(i)*e_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*e_vec(i)*e_vec(i)
  enddo
  return

end

! Niveau 1 (32 mult, 15 add, 47 total, 1.175 Flop/B)
subroutine test4(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*b_vec(i)*b_vec(i) &
            -b_vec(i)*b_vec(i)*c_vec(i) &
            +b_vec(i)*b_vec(i)*d_vec(i) &
            -b_vec(i)*b_vec(i)*e_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*e_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i)*c_vec(i) &
            -c_vec(i)*c_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*e_vec(i) &
            -c_vec(i)*d_vec(i)*d_vec(i) &
            +c_vec(i)*d_vec(i)*e_vec(i) &
            -c_vec(i)*e_vec(i)*e_vec(i)
  enddo
  return

end

! Niveau 1 (40 mult, 19 add, 59 total, 1.475 Flop/B)
subroutine test5(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*b_vec(i)*b_vec(i) &
            -b_vec(i)*b_vec(i)*c_vec(i) &
            +b_vec(i)*b_vec(i)*d_vec(i) &
            -b_vec(i)*b_vec(i)*e_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*e_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i)*c_vec(i) &
            -c_vec(i)*c_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*e_vec(i) &
            -c_vec(i)*d_vec(i)*d_vec(i) &
            +c_vec(i)*d_vec(i)*e_vec(i) &
            -c_vec(i)*e_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i)*d_vec(i) &
            -d_vec(i)*d_vec(i)*e_vec(i) &
            +d_vec(i)*e_vec(i)*e_vec(i) &
            -e_vec(i)*e_vec(i)*e_vec(i)
  enddo
  return

end


! Niveau 2 (50 mult, 29 add, 79 total, 1.975 Flop/B)
subroutine test6(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*b_vec(i) &
            +b_vec(i)*c_vec(i) &
            +b_vec(i)*d_vec(i) &
            +b_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i) &
            +c_vec(i)*d_vec(i) &
            +c_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i) &
            +d_vec(i)*e_vec(i) &
            +e_vec(i)*e_vec(i) &
            +b_vec(i)*b_vec(i)*b_vec(i) &
            -b_vec(i)*b_vec(i)*c_vec(i) &
            +b_vec(i)*b_vec(i)*d_vec(i) &
            -b_vec(i)*b_vec(i)*e_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*e_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i)*c_vec(i) &
            -c_vec(i)*c_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*e_vec(i) &
            -c_vec(i)*d_vec(i)*d_vec(i) &
            +c_vec(i)*d_vec(i)*e_vec(i) &
            -c_vec(i)*e_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i)*d_vec(i) &
            -d_vec(i)*d_vec(i)*e_vec(i) &
            +d_vec(i)*e_vec(i)*e_vec(i) &
            -e_vec(i)*e_vec(i)*e_vec(i)
  enddo
  return

end

! Niveau 3 (93 mult, 30 add, 123 total, 3.075 Flop/B)
subroutine test7(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*b_vec(i)*b_vec(i)*c_vec(i) &
            +b_vec(i)*b_vec(i)*b_vec(i)*d_vec(i) &
            -b_vec(i)*b_vec(i)*b_vec(i)*e_vec(i) &
            +b_vec(i)*b_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*b_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*b_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*b_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*b_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*b_vec(i)*e_vec(i)*e_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*c_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*c_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*c_vec(i)*e_vec(i)*e_vec(i) &
            +b_vec(i)*d_vec(i)*d_vec(i)*d_vec(i) &
            -b_vec(i)*d_vec(i)*d_vec(i)*e_vec(i) &
            +b_vec(i)*d_vec(i)*e_vec(i)*e_vec(i) &
            -b_vec(i)*e_vec(i)*e_vec(i)*e_vec(i) &
            -c_vec(i)*c_vec(i)*c_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*c_vec(i)*e_vec(i) &
            -c_vec(i)*c_vec(i)*d_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*d_vec(i)*e_vec(i) &
            -c_vec(i)*c_vec(i)*e_vec(i)*e_vec(i) &
            +c_vec(i)*d_vec(i)*d_vec(i)*d_vec(i) &
            -c_vec(i)*d_vec(i)*d_vec(i)*e_vec(i) &
            +c_vec(i)*d_vec(i)*e_vec(i)*e_vec(i) &
            -c_vec(i)*e_vec(i)*e_vec(i)*e_vec(i) &
            -d_vec(i)*d_vec(i)*d_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i)*e_vec(i)*e_vec(i) &
            -d_vec(i)*e_vec(i)*e_vec(i)*e_vec(i)
  enddo
  return
end


! Niveau 3 (155 mult, 64 add, 219 total, 5.475 Flop/B)
subroutine test8(a_vec,b_vec,c_vec,d_vec,e_vec,n)
  real(kind=8) a_vec(*), b_vec(*), c_vec(*), d_vec(*), e_vec(*)
  integer :: n

  !$omp parallel do schedule(static)
  do i=1,n
    a_vec(i)=b_vec(i)*b_vec(i) &
            +b_vec(i)*c_vec(i) &
            +b_vec(i)*d_vec(i) &
            +b_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i) &
            +c_vec(i)*d_vec(i) &
            +c_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i) &
            +d_vec(i)*e_vec(i) &
            +e_vec(i)*e_vec(i) &
            +b_vec(i)*b_vec(i)*b_vec(i) &
            -b_vec(i)*b_vec(i)*c_vec(i) &
            +b_vec(i)*b_vec(i)*d_vec(i) &
            -b_vec(i)*b_vec(i)*e_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*e_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i)*c_vec(i) &
            -c_vec(i)*c_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*e_vec(i) &
            -c_vec(i)*d_vec(i)*d_vec(i) &
            +c_vec(i)*d_vec(i)*e_vec(i) &
            -c_vec(i)*e_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i)*d_vec(i) &
            -d_vec(i)*d_vec(i)*e_vec(i) &
            +d_vec(i)*e_vec(i)*e_vec(i) &
            -e_vec(i)*e_vec(i)*e_vec(i) &
            +b_vec(i)*b_vec(i)*b_vec(i)*b_vec(i) &
            -b_vec(i)*b_vec(i)*b_vec(i)*c_vec(i) &
            +b_vec(i)*b_vec(i)*b_vec(i)*d_vec(i) &
            -b_vec(i)*b_vec(i)*b_vec(i)*e_vec(i) &
            +b_vec(i)*b_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*b_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*b_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*b_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*b_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*b_vec(i)*e_vec(i)*e_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i)*c_vec(i) &
            -b_vec(i)*c_vec(i)*c_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*c_vec(i)*e_vec(i) &
            -b_vec(i)*c_vec(i)*d_vec(i)*d_vec(i) &
            +b_vec(i)*c_vec(i)*d_vec(i)*e_vec(i) &
            -b_vec(i)*c_vec(i)*e_vec(i)*e_vec(i) &
            +b_vec(i)*d_vec(i)*d_vec(i)*d_vec(i) &
            -b_vec(i)*d_vec(i)*d_vec(i)*e_vec(i) &
            +b_vec(i)*d_vec(i)*e_vec(i)*e_vec(i) &
            -b_vec(i)*e_vec(i)*e_vec(i)*e_vec(i) &
            +c_vec(i)*c_vec(i)*c_vec(i)*c_vec(i) &
            -c_vec(i)*c_vec(i)*c_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*c_vec(i)*e_vec(i) &
            -c_vec(i)*c_vec(i)*d_vec(i)*d_vec(i) &
            +c_vec(i)*c_vec(i)*d_vec(i)*e_vec(i) &
            -c_vec(i)*c_vec(i)*e_vec(i)*e_vec(i) &
            +c_vec(i)*d_vec(i)*d_vec(i)*d_vec(i) &
            -c_vec(i)*d_vec(i)*d_vec(i)*e_vec(i) &
            +c_vec(i)*d_vec(i)*e_vec(i)*e_vec(i) &
            -c_vec(i)*e_vec(i)*e_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i)*d_vec(i)*d_vec(i) &
            -d_vec(i)*d_vec(i)*d_vec(i)*e_vec(i) &
            +d_vec(i)*d_vec(i)*e_vec(i)*e_vec(i) &
            -d_vec(i)*e_vec(i)*e_vec(i)*e_vec(i) &
            +e_vec(i)*e_vec(i)*e_vec(i)*e_vec(i)
  enddo
  return
end



