#include "amgx_c.h"
#include "amgx_config.h"

#ifdef MPI
#include <mpi.h> 
#endif


/* Build */
AMGX_RC AMGX_API amgx_get_api_version(int *major, int *minor)
{
	AMGX_get_api_version(major, minor);
}

AMGX_RC AMGX_API amgx_get_build_info_strings(char **version, char **date, char **time)
{
	AMGX_get_build_info_strings(version, date, time);
}

AMGX_RC AMGX_API amgx_get_error_string(AMGX_RC err, char *buf, int buf_len)
{
	AMGX_get_error_string(err, buf, buf_len);
}


/* Init & Shutdown */
AMGX_RC AMGX_API amgx_initialize()
{
	AMGX_initialize();
}

AMGX_RC AMGX_API amgx_initialize_plugins()
{
	AMGX_initialize_plugins();
}

AMGX_RC AMGX_API amgx_finalize()
{
	AMGX_finalize();
}

AMGX_RC AMGX_API amgx_finalize_plugins()
{
	AMGX_finalize_plugins();
}

void AMGX_API amgx_abort(AMGX_resources_handle rsrc, int err)
{
	AMGX_abort(rsrc, err);
}


/* System */
AMGX_RC AMGX_API amgx_pin_memory(void *ptr, unsigned int bytes)
{
	AMGX_pin_memory(ptr, bytes);
}

AMGX_RC AMGX_API amgx_unpin_memory(void *ptr)
{
	AMGX_unpin_memory(ptr);
}

AMGX_RC AMGX_API amgx_install_signal_handler()
{
	AMGX_install_signal_handler();
}

AMGX_RC AMGX_API amgx_reset_signal_handler()
{
	AMGX_reset_signal_handler();
}

#ifdef MPI
MPI_Comm* amgx_comm;
void print_callback(const char *msg, int length)
	{
		int rank;
		MPI_Comm_rank(*amgx_comm, &rank);
		if (rank == 0) { printf("%s", msg); }
	}
AMGX_RC AMGX_API amgx_register_print_callback(MPI_Comm *comm)
{
        amgx_comm = comm;
	AMGX_register_print_callback(&print_callback);
}
#endif


/* Resources */
AMGX_RC AMGX_API amgx_resources_create_simple(AMGX_resources_handle *rsc, AMGX_config_handle cfg)
{
	AMGX_resources_create_simple(rsc,cfg);
}

AMGX_RC AMGX_API amgx_resources_create(AMGX_resources_handle *rsc, AMGX_config_handle cfg, void *comm, int device_num, const int *devices)
{
	AMGX_resources_create(rsc, cfg, comm, device_num, devices);
}

AMGX_RC AMGX_API amgx_resources_destroy(AMGX_resources_handle rsc)
{
	AMGX_resources_destroy(rsc);
}


/* Config */

AMGX_RC AMGX_API amgx_config_create(AMGX_config_handle *cfg, const char *options)
{
	AMGX_config_create(cfg, options);
}

AMGX_RC AMGX_API amgx_config_add_parameters(AMGX_config_handle *cfg, const char *options)
{
	AMGX_config_add_parameters(cfg, options);
}

AMGX_RC AMGX_API amgx_config_create_from_file_and_string(AMGX_config_handle *cfg, const char *param_file, const char *options)
{
	AMGX_config_create_from_file_and_string(cfg, param_file, options);
}

AMGX_RC AMGX_API amgx_config_create_from_file(AMGX_config_handle *cfg, const char *param_file)
{
	AMGX_config_create_from_file(cfg,param_file);
}

AMGX_RC AMGX_API amgx_config_get_default_number_of_rings(AMGX_config_handle cfg, int *num_import_rings)
{
	AMGX_config_get_default_number_of_rings(cfg, num_import_rings);
}

AMGX_RC AMGX_API amgx_config_destroy(AMGX_config_handle cfg)
{
	AMGX_config_destroy(cfg);
}


/* Utilities */
AMGX_RC AMGX_API amgx_read_system(AMGX_matrix_handle mtx, AMGX_vector_handle rhs,AMGX_vector_handle sol, const char *filename)
{
	AMGX_read_system(mtx, rhs, sol, filename);
}

AMGX_RC AMGX_API amgx_read_system_distributed(AMGX_matrix_handle mtx, AMGX_vector_handle rhs, AMGX_vector_handle sol, const char *filename, int allocated_halo_depth, int num_partitions, const int *partition_sizes, int partition_vector_size, const int *partition_vector)
{
	AMGX_read_system_distributed(mtx, rhs, sol, filename, allocated_halo_depth, num_partitions, partition_sizes, partition_vector_size, partition_vector);
}

AMGX_RC AMGX_API amgx_write_system(const AMGX_matrix_handle mtx, const AMGX_vector_handle rhs, const AMGX_vector_handle sol, const char *filename)
{
	AMGX_write_system(mtx, rhs, sol, filename);
}

AMGX_RC AMGX_API amgx_write_system_distributed(const AMGX_matrix_handle mtx, const AMGX_vector_handle rhs, const AMGX_vector_handle sol, const char *filename, int allocated_halo_depth, int num_partitions, const int *partition_sizes, int partition_vector_size, const int *partition_vector)
{
	AMGX_write_system_distributed(mtx, rhs, sol, filename, allocated_halo_depth, num_partitions, partition_sizes, partition_vector_size, partition_vector);
}

AMGX_RC AMGX_API amgx_read_system_maps_one_ring(int *n, int *nnz, int *block_dimx, int *block_dimy, int **row_ptrs, int **col_indices, void **data, void **diag_data, void **rhs, void **sol, int *num_neighbors, int **neighbors, int **send_sizes, int ***send_maps, int **recv_sizes, int ***recv_maps, AMGX_resources_handle rsc, AMGX_Mode mode, const char *filename, int allocated_halo_depth, int num_partitions, const int *partition_sizes, int partition_vector_size, const int *partition_vector)
{
	AMGX_read_system_maps_one_ring(n, nnz, block_dimx, block_dimy, row_ptrs, col_indices, data, diag_data, rhs, sol, num_neighbors, neighbors, send_sizes, send_maps, recv_sizes, recv_maps, rsc, mode, filename, allocated_halo_depth, num_partitions, partition_sizes, partition_vector_size, partition_vector);
}

AMGX_RC AMGX_API amgx_free_system_maps_one_ring(int *row_ptrs, int *col_indices, void *data, void *diag_data, void *rhs, void *sol, int num_neighbors, int *neighbors, int *send_sizes, int **send_maps, int *recv_sizes, int **recv_maps)
{
	AMGX_free_system_maps_one_ring(row_ptrs, col_indices, data, diag_data, rhs, sol, num_neighbors, neighbors, send_sizes, send_maps, recv_sizes, recv_maps);
}

AMGX_RC AMGX_API amgx_generate_distributed_poisson_7pt(AMGX_matrix_handle mtx, AMGX_vector_handle rhs, AMGX_vector_handle sol, int allocated_halo_depth, int num_import_rings, int nx, int ny, int nz, int px, int py, int pz)
{
	AMGX_generate_distributed_poisson_7pt(mtx, rhs, sol, allocated_halo_depth, num_import_rings, nx, ny, nz, px, py, pz);
}

AMGX_RC AMGX_API amgx_write_parameters_description(char *filename, AMGX_GET_PARAMS_DESC_FLAG mode)
{
	AMGX_write_parameters_description(filename, mode);
}


/* Solver */
AMGX_RC AMGX_API amgx_solver_create(AMGX_solver_handle *slv, AMGX_resources_handle rsc, AMGX_Mode mode, const AMGX_config_handle cfg_solver)
{
	AMGX_solver_create(slv, rsc, mode, cfg_solver);
}

AMGX_RC AMGX_API amgx_solver_setup(AMGX_solver_handle slv, AMGX_matrix_handle mtx)
{
	AMGX_solver_setup(slv, mtx);
}

AMGX_RC AMGX_API amgx_solver_solve(AMGX_solver_handle slv, AMGX_vector_handle rhs, AMGX_vector_handle sol)
{
	AMGX_solver_solve(slv, rhs, sol);
}

AMGX_RC AMGX_API amgx_solver_get_status(AMGX_solver_handle slv, AMGX_SOLVE_STATUS *st)
{
	AMGX_solver_get_status(slv, st);
}

AMGX_RC AMGX_API amgx_solver_get_iterations_number(AMGX_solver_handle slv, int *n)
{
	AMGX_solver_get_iterations_number(slv, n);
}

AMGX_RC AMGX_API amgx_solver_get_iteration_residual(AMGX_solver_handle slv, int it, int idx, double *res)
{
	AMGX_solver_get_iteration_residual(slv, it, idx, res);
}

AMGX_RC AMGX_API amgx_solver_destroy(AMGX_solver_handle slv)
{
	AMGX_solver_destroy(slv);
}


/* Matrix */
AMGX_RC AMGX_API amgx_matrix_create(AMGX_matrix_handle *mtx, AMGX_resources_handle rsc, AMGX_Mode mode)
{
	AMGX_matrix_create(mtx, rsc, mode);
}

AMGX_RC AMGX_API amgx_matrix_vector_multiply(AMGX_matrix_handle mtx, AMGX_vector_handle x, AMGX_vector_handle y)
{
	AMGX_matrix_vector_multiply(mtx, x, y);
}

AMGX_RC AMGX_API amgx_matrix_get_size(const AMGX_matrix_handle mtx, int *n, int *block_dimx, int *block_dimy)
{
	AMGX_matrix_get_size(mtx, n, block_dimx, block_dimy);
}

AMGX_RC AMGX_API amgx_matrix_destroy(AMGX_matrix_handle mtx)
{
	AMGX_matrix_destroy(mtx);
}

AMGX_RC AMGX_API amgx_matrix_upload_all(AMGX_matrix_handle mtx, int n, int nnz, int block_dimx, int block_dimy, const int *row_ptrs, const int *col_indices, const void *data, const void *diag_data)
{
	AMGX_matrix_upload_all(mtx, n, nnz, block_dimx, block_dimy, row_ptrs, col_indices, data, diag_data);
}

AMGX_RC AMGX_API amgx_matrix_replace_coefficients(AMGX_matrix_handle mtx, int n, int nnz, const void *data, const void *diag_data)
{
	AMGX_matrix_replace_coefficients(mtx, n, nnz, data, diag_data);
}

AMGX_RC AMGX_API amgx_matrix_get_nnz(const AMGX_matrix_handle mtx, int *nnz)
{
	AMGX_matrix_get_nnz(mtx, nnz);
}

AMGX_RC AMGX_API amgx_matrix_download_all(const AMGX_matrix_handle mtx, int *row_ptrs, int *col_indices, void *data, void **diag_data)
{
	AMGX_matrix_download_all(mtx, row_ptrs, col_indices, data, diag_data);
}

AMGX_RC AMGX_API amgx_matrix_set_boundary_separation(AMGX_matrix_handle mtx, int boundary_separation)
{
	AMGX_matrix_set_boundary_separation(mtx, boundary_separation);
}

AMGX_RC AMGX_API amgx_matrix_comm_from_maps(AMGX_matrix_handle mtx, int allocated_halo_depth, int num_import_rings, int max_num_neighbors, const int *neighbors, const int *send_ptrs, const int *send_maps, const int *recv_ptrs, const int *recv_maps)
{
	AMGX_matrix_comm_from_maps(mtx, allocated_halo_depth, num_import_rings, max_num_neighbors, neighbors, send_ptrs, send_maps, recv_ptrs, recv_maps);
}

AMGX_RC AMGX_API amgx_matrix_comm_from_maps_one_ring(AMGX_matrix_handle mtx, int allocated_halo_depth, int num_neighbors, const int *neighbors, const int *send_sizes, const int **send_maps, const int *recv_sizes, const int **recv_maps)
{
	AMGX_matrix_comm_from_maps_one_ring(mtx, allocated_halo_depth, num_neighbors, neighbors, send_sizes, send_maps, recv_sizes, recv_maps);
}

AMGX_RC AMGX_API amgx_matrix_upload_all_global(AMGX_matrix_handle mtx, int n_global, int n, int nnz, int block_dimx, int block_dimy, const int *row_ptrs, const void *col_indices_global, const void *data, const void *diag_data, int allocated_halo_depth, int num_import_rings, const int *partition_vector)
{
	AMGX_matrix_upload_all_global(mtx, n_global, n, nnz, block_dimx, block_dimy, row_ptrs, col_indices_global, data, diag_data, allocated_halo_depth, num_import_rings, partition_vector);
}

AMGX_RC AMGX_API amgx_matrix_upload_all_global_32(AMGX_matrix_handle mtx, int n_global, int n, int nnz, int block_dimx, int block_dimy, const int *row_ptrs, const void *col_indices_global, const void *data, const void *diag_data, int allocated_halo_depth, int num_import_rings, const int *partition_vector)
{
	AMGX_matrix_upload_all_global_32(mtx, n_global, n, nnz, block_dimx, block_dimy, row_ptrs, col_indices_global, data, diag_data, allocated_halo_depth, num_import_rings, partition_vector);
}



/* Vector */
AMGX_RC AMGX_API amgx_vector_create(AMGX_vector_handle *vec, AMGX_resources_handle rsc, AMGX_Mode mode)
{
	AMGX_vector_create(vec, rsc, mode);
}

AMGX_RC AMGX_API amgx_vector_download(const AMGX_vector_handle vec, void *data)
{
	AMGX_vector_download(vec, data);
}

AMGX_RC AMGX_API amgx_vector_upload(AMGX_vector_handle vec, int n, int block_dim, const void *data)
{
	AMGX_vector_upload(vec, n, block_dim, data);
}

AMGX_RC AMGX_API amgx_vector_set_random(AMGX_vector_handle vec, int n)
{
	AMGX_vector_set_random(vec, n);
}

AMGX_RC AMGX_API amgx_vector_set_zero(AMGX_vector_handle vec, int n, int block_dim)
{
	AMGX_vector_set_zero(vec, n, block_dim);
}

AMGX_RC AMGX_API amgx_vector_destroy(AMGX_vector_handle vec)
{
	AMGX_vector_destroy(vec);
}

AMGX_RC AMGX_API amgx_vector_get_size(const AMGX_vector_handle vec, int *n, int *block_dim)
{
	AMGX_vector_get_size(vec, n, block_dim);
}

AMGX_RC AMGX_API amgx_vector_bind(AMGX_vector_handle vec, const AMGX_matrix_handle mtx)
{
	AMGX_vector_bind(vec, mtx);
}


#ifdef MPI
MPI_Comm* mpi_comm_f2c(MPI_Fint f_comm)
{   
	MPI_Comm* c_comm;
	c_comm = malloc(sizeof(MPI_Comm));
	*c_comm = MPI_Comm_f2c(f_comm);
	return c_comm;
}
#endif



