module amgx_fortran
use, intrinsic :: iso_c_binding
interface


!/* Build */
  subroutine AMGX_get_api_version(major, minor) bind(C, name='amgx_get_api_version')
    use iso_c_binding
    integer :: major, minor
  end subroutine amgx_get_api_version

  subroutine AMGX_get_build_info_strings(version, date, time) bind(C, name='amgx_get_build_info_strings')
    use iso_c_binding
    type(c_ptr), value :: version, date, time
  end subroutine amgx_get_build_info_strings

  subroutine AMGX_get_error_string(aerr, buf, buf_len) bind(C, name='amgx_get_error_string')
    use iso_c_binding
    type(c_ptr), value :: aerr, buf
    integer, value :: buf_len
  end subroutine amgx_get_error_string


!/* Init & Shutdown */
  subroutine AMGX_initialize() bind(C, name='amgx_initialize')
  end subroutine amgx_initialize

  subroutine AMGX_initialize_plugins() bind(C, name='amgx_initialize_plugins')
  end subroutine amgx_initialize_plugins

  subroutine AMGX_finalize() bind(C, name='amgx_finalize')
  end subroutine amgx_finalize

  subroutine AMGX_finalize_plugins() bind(C, name='amgx_finalize_plugins')
  end subroutine amgx_finalize_plugins

  subroutine AMGX_abort(rsrc, ierr) bind(C, name='amgx_abort')
    use iso_c_binding
    type(c_ptr), value :: rsrc
    integer, value :: ierr
  end subroutine amgx_abort


!/* System */
  subroutine AMGX_pin_memory(rdata,bytes) bind(C, name='amgx_pin_memory')
    use iso_c_binding
    real(kind=8) :: rdata
    integer, value :: bytes
  end subroutine AMGX_pin_memory

  subroutine AMGX_unpin_memory(rdata,bytes) bind(C, name='amgx_unpin_memory')
    use iso_c_binding
    real(kind=8) :: rdata
  end subroutine AMGX_unpin_memory

  subroutine AMGX_install_signal_handler() bind(C, name='amgx_install_signal_handler')
  end subroutine AMGX_install_signal_handler

  subroutine AMGX_reset_signal_handler() bind(C, name='amgx_reset_signal_handler')
  end subroutine AMGX_reset_signal_handler

  subroutine AMGX_register_print_callback(comm) bind(C, name='amgx_register_print_callback')
    use iso_c_binding
    type(c_ptr), value :: comm
  end subroutine AMGX_register_print_callback

!/* Config */
  subroutine AMGX_config_create_from_file(cfg,param_file) bind(C, name='amgx_config_create_from_file')
    use iso_c_binding
    type(c_ptr) :: cfg
    type(c_ptr), value :: param_file
  end subroutine AMGX_config_create_from_file

  subroutine AMGX_config_create(cfg,options) bind(C, name='amgx_config_create')
    use iso_c_binding
    type(c_ptr) :: cfg
    type(c_ptr), value :: options
  end subroutine AMGX_config_create

  subroutine AMGX_config_add_parameters(cfg,options) bind(C, name='amgx_config_add_parameters')
    use iso_c_binding
    type(c_ptr), value :: cfg, options
  end subroutine AMGX_config_add_parameters

  subroutine AMGX_config_create_from_file_and_string(cfg,param_file,options) bind(C, name='amgx_config_create_from_file_and_string')
    use iso_c_binding
    type(c_ptr) :: cfg
    type(c_ptr), value :: param_file, options
  end subroutine AMGX_config_create_from_file_and_string

  subroutine AMGX_config_get_default_number_of_rings(cfg,num_import_rings) bind(C, name='amgx_config_get_default_number_of_rings')
    use iso_c_binding
    type(c_ptr), value :: cfg
    integer :: num_import_rings
  end subroutine AMGX_config_get_default_number_of_rings

  subroutine AMGX_config_destroy(cfg) bind(C, name='amgx_config_destroy')
    use iso_c_binding
    type(c_ptr), value :: cfg
  end subroutine AMGX_config_destroy


!/* Resources */
  subroutine AMGX_resources_create_simple(rsc,cfg) bind(C, name='amgx_resources_create_simple')
    use iso_c_binding
    type(c_ptr) :: rsc
    type(c_ptr), value :: cfg
  end subroutine AMGX_resources_create_simple

  subroutine AMGX_resources_create(rsc, cfg, comm, device_num, devices) bind(C, name='amgx_resources_create')
    use iso_c_binding
    type(c_ptr) :: rsc
    type(c_ptr), value :: cfg, comm, devices
    integer, value :: device_num
  end subroutine AMGX_resources_create

  subroutine AMGX_resources_destroy(rsc) bind(C, name='amgx_resources_destroy')
    use iso_c_binding
    type(c_ptr), value :: rsc
  end subroutine AMGX_resources_destroy


!/* Solver */
  subroutine AMGX_solver_create(slv, rsc, mode, cfg_solver) bind(C, name='amgx_solver_create')
    use iso_c_binding
    type(c_ptr) :: slv
    type(c_ptr), value :: rsc, cfg_solver
    integer, value :: mode
  end subroutine AMGX_solver_create

  subroutine AMGX_solver_setup(slv, mtx) bind(C, name='amgx_solver_setup')
    use iso_c_binding
    type(c_ptr), value :: slv, mtx
  end subroutine AMGX_solver_setup

  subroutine AMGX_solver_solve(slv, rhs, sol) bind(C, name='amgx_solver_solve')
    use iso_c_binding
    type(c_ptr), value :: slv, rhs, sol
  end subroutine AMGX_solver_solve

  subroutine AMGX_solver_destroy(slv) bind(C, name='amgx_solver_destroy')
    use iso_c_binding
    type(c_ptr), value :: slv
  end subroutine AMGX_solver_destroy

  subroutine AMGX_solver_get_status(slv, st) bind(C, name='amgx_solver_get_status')
    use iso_c_binding
    type(c_ptr), value :: slv
    integer :: st
  end subroutine AMGX_solver_get_status

  subroutine AMGX_solver_get_iterations_number(slv, n) bind(C, name='amgx_solver_get_iterations_number')
    use iso_c_binding
    type(c_ptr), value :: slv
    integer :: n
  end subroutine AMGX_solver_get_iterations_number

  subroutine AMGX_solver_get_iteration_residual(slv, it, idx, res) bind(C, name='amgx_solver_get_iteration_residual')
    use iso_c_binding
    type(c_ptr), value :: slv
    integer, value :: it, idx
    double precision :: res
  end subroutine AMGX_solver_get_iteration_residual


!/* Matrix */
  subroutine AMGX_matrix_create(mtx, rsc, mode) bind(C, name='amgx_matrix_create')
    use iso_c_binding
    type(c_ptr) :: mtx
    type(c_ptr), value :: rsc
    integer, value :: mode
  end subroutine AMGX_matrix_create

  subroutine AMGX_matrix_vector_multiply(mtx, x, y) bind(C, name='amgx_matrix_vector_multiply')
    use iso_c_binding
    type(c_ptr), value :: mtx, x, y
  end subroutine AMGX_matrix_vector_multiply

  subroutine AMGX_matrix_get_size(mtx, n, block_dimx, block_dimy) bind(C, name='amgx_matrix_get_size')
    use iso_c_binding
    type(c_ptr), value :: mtx
    integer :: n, block_dimx, block_dimy
  end subroutine AMGX_matrix_get_size

  subroutine AMGX_matrix_destroy(mtx) bind(C, name='amgx_matrix_destroy')
    use iso_c_binding
    type(c_ptr), value :: mtx
  end subroutine AMGX_matrix_destroy

  subroutine AMGX_matrix_upload_all(mtx, n, nnz, block_dimx, block_dimy, row_ptrs, col_indices, rdata, diag_rdata) bind(C, name='amgx_matrix_upload_all')
    use iso_c_binding
    type(c_ptr), value :: mtx, row_ptrs, col_indices, rdata, diag_rdata
    integer, value :: n, nnz, block_dimx, block_dimy
  end subroutine AMGX_matrix_upload_all

  subroutine AMGX_matrix_replace_coefficients(mtx, n, nnz, rdata, diag_rdata) bind(C, name='amgx_matrix_replace_coefficients')
    use iso_c_binding
    type(c_ptr), value :: mtx, rdata, diag_rdata
    integer, value :: n, nnz
  end subroutine AMGX_matrix_replace_coefficients

  subroutine AMGX_matrix_get_nnz(mtx, nnz) bind(C, name='amgx_matrix_get_nnz')
    use iso_c_binding
    type(c_ptr), value :: mtx
    integer :: nnz
  end subroutine AMGX_matrix_get_nnz

  subroutine AMGX_matrix_download_all(mtx, row_ptrs, col_indices, rdata, diag_rdata) bind(C, name='amgx_matrix_download_all')
    use iso_c_binding
    type(c_ptr), value :: mtx, row_ptrs, col_indices, rdata, diag_rdata
  end subroutine AMGX_matrix_download_all

  subroutine AMGX_matrix_set_boundary_separation(mtx, boundary_separation) bind(C, name='amgx_matrix_set_boundary_separation')
    use iso_c_binding
    type(c_ptr), value :: mtx
    integer, value :: boundary_separation
  end subroutine AMGX_matrix_set_boundary_separation

  subroutine AMGX_matrix_comm_from_maps(mtx, allocated_halo_depth, num_import_rings, max_num_neighbors, neighbors, send_ptrs, send_maps, recv_ptrs, recv_maps) bind(C, name='amgx_matrix_comm_from_maps')
    use iso_c_binding
    type(c_ptr), value :: mtx, neighbors, send_ptrs, send_maps, recv_ptrs, recv_maps
    integer, value :: allocated_halo_depth, num_import_rings, max_num_neighbors
  end subroutine AMGX_matrix_comm_from_maps

  subroutine AMGX_matrix_comm_from_maps_one_ring(mtx, allocated_halo_depth, num_neighbors, neighbors, send_sizes, send_maps, recv_sizes, recv_maps) bind(C, name='amgx_matrix_comm_from_maps_one_ring')
    use iso_c_binding
    type(c_ptr), value :: mtx, neighbors, send_sizes, send_maps, recv_sizes, recv_maps
    integer, value :: allocated_halo_depth, num_neighbors
  end subroutine AMGX_matrix_comm_from_maps_one_ring

  subroutine AMGX_matrix_upload_all_global(mtx, n_global, n, nnz, block_dimx, block_dimy, row_ptrs, col_indices_global, rdata, diag_rdata, allocated_halo_depth, num_import_rings, partition_vector) bind(C, name='amgx_matrix_upload_all_global')
    use iso_c_binding
    type(c_ptr), value :: mtx, row_ptrs, col_indices_global, rdata, diag_rdata, partition_vector
    integer, value :: n_global, n, nnz, block_dimx, block_dimy, allocated_halo_depth, num_import_rings
  end subroutine AMGX_matrix_upload_all_global

  subroutine AMGX_matrix_upload_all_global_32(mtx, n_global, n, nnz, block_dimx, block_dimy, row_ptrs, col_indices_global, rdata, diag_rdata, allocated_halo_depth, num_import_rings, partition_vector) bind(C, name='amgx_matrix_upload_all_global_32')
    use iso_c_binding
    type(c_ptr), value :: mtx, row_ptrs, col_indices_global, rdata, diag_rdata, partition_vector
    integer, value :: n_global, n, nnz, block_dimx, block_dimy, allocated_halo_depth, num_import_rings
  end subroutine AMGX_matrix_upload_all_global_32


!/* Vector */
  subroutine AMGX_vector_create(vec, rsc, mode) bind(C, name='amgx_vector_create')
    use iso_c_binding
    type(c_ptr) :: vec
    type(c_ptr), value :: rsc
    integer, value :: mode
  end subroutine AMGX_vector_create

  subroutine AMGX_vector_download(vec, rdata) bind(C, name='amgx_vector_download')
    use iso_c_binding
    type(c_ptr), value :: vec, rdata 
  end subroutine AMGX_vector_download

  subroutine AMGX_vector_upload(vec, n, block_dim, rdata) bind(C, name='amgx_vector_upload')
    use iso_c_binding
    type(c_ptr), value :: vec, rdata
    integer, value :: n, block_dim
  end subroutine AMGX_vector_upload

  subroutine AMGX_vector_set_random(vec,n) bind(C, name='amgx_vector_set_random')
    use iso_c_binding
    type(c_ptr), value :: vec
    integer, value :: n
  end subroutine AMGX_vector_set_random

  subroutine AMGX_vector_set_zero(vec,n,block_dim) bind(C, name='amgx_vector_set_zero')
    use iso_c_binding
    type(c_ptr), value :: vec
    integer, value :: n, block_dim
  end subroutine AMGX_vector_set_zero

  subroutine AMGX_vector_destroy(vec) bind(C, name='amgx_vector_destroy')
    use iso_c_binding
    type(c_ptr), value :: vec
  end subroutine AMGX_vector_destroy

  subroutine AMGX_vector_get_size(vec, n, block_dim) bind(C, name='amgx_vector_get_size')
    use iso_c_binding
    type(c_ptr), value :: vec
    integer :: n, block_dim
  end subroutine AMGX_vector_get_size

  subroutine AMGX_vector_bind(vec, mtx) bind(C, name='amgx_vector_bind')
    use iso_c_binding
    type(c_ptr), value :: vec, mtx
  end subroutine AMGX_vector_bind


!/* Utilities */
  subroutine AMGX_read_system(A,x,b,mat) bind(C, name='amgx_read_system')
    use iso_c_binding
    type(c_ptr), value :: A, b, x, mat
  end subroutine AMGX_read_system

  subroutine AMGX_read_system_distributed(mtx, rhs, sol, filename, allocated_halo_depth, num_partitions, partition_sizes, partition_vector_size, partition_vector) bind(C, name='amgx_read_system_distributed')
    use iso_c_binding
    type(c_ptr), value :: mtx, rhs, sol, filename, partition_sizes, partition_vector
    integer, value :: allocated_halo_depth, num_partitions, partition_vector_size
  end subroutine AMGX_read_system_distributed

  subroutine AMGX_write_system(mtx,sol,rhs,mat) bind(C, name='amgx_write_system')
    use iso_c_binding
    type(c_ptr), value :: mtx, rhs, sol, mat
  end subroutine AMGX_write_system

  subroutine AMGX_write_system_distributed(mtx, rhs, sol, filename, allocated_halo_depth, num_partitions, partition_sizes, partition_vector_size, partition_vector) bind(C, name='amgx_write_system_distributed')
    use iso_c_binding
    type(c_ptr), value :: mtx, rhs, sol, filename, partition_sizes, partition_vector
    integer, value :: allocated_halo_depth, num_partitions, partition_vector_size
  end subroutine AMGX_write_system_distributed

  subroutine AMGX_read_system_maps_one_ring(n, nnz, block_dimx, block_dimy, row_ptrs, col_indices, rdata, diag_rdata, rhs, sol, num_neighbors, neighbors, send_sizes, send_maps, recv_sizes, recv_maps, rsc, mode, filename, allocated_halo_depth, num_partitions, partition_sizes, partition_vector_size, partition_vector) bind(C, name='amgx_read_system_maps_one_ring')
    use iso_c_binding
    type(c_ptr), value :: rdata, diag_rdata, rhs, sol, filename, partition_sizes, partition_vector, rsc, row_ptrs, col_indices, neighbors, send_sizes, send_maps, recv_sizes, recv_maps
    integer :: n, nnz, block_dimx, block_dimy, num_neighbors
    integer, value :: allocated_halo_depth, num_partitions, partition_vector_size, mode
  end subroutine AMGX_read_system_maps_one_ring

  subroutine AMGX_free_system_maps_one_ring(row_ptrs, col_indices, rdata, diag_rdata, rhs, sol, num_neighbors, neighbors, send_sizes, send_maps, recv_sizes, recv_maps) bind(C, name='amgx_free_system_maps_one_ring')
    use iso_c_binding
    type(c_ptr), value :: row_ptrs, col_indices, rdata, diag_rdata, rhs, sol, neighbors, send_sizes, send_maps, recv_sizes, recv_maps
    integer, value :: num_neighbors
  end subroutine AMGX_free_system_maps_one_ring

  subroutine AMGX_generate_distributed_poisson_7pt(mtx, rhs, sol, allocated_halo_depth, num_import_rings, nx, ny, nz, px, py, pz) bind(C, name='amgx_generate_distributed_poisson_7pt')
    use iso_c_binding
    type(c_ptr), value :: mtx, rhs, sol
    integer, value :: allocated_halo_depth, num_import_rings, nx, ny, nz, px, py, pz
  end subroutine AMGX_generate_distributed_poisson_7pt

  subroutine AMGX_write_parameters_description(filename, mode) bind(C, name='amgx_write_parameters_description')
    use iso_c_binding
    type(c_ptr), value :: filename
    integer, value :: mode
  end subroutine AMGX_write_parameters_description


!/* MPI */
  function MPI_comm_f2c(f_comm) result(c_comm) bind(C,name='mpi_comm_f2c')
    use iso_c_binding
    integer, value :: f_comm
    type(c_ptr) :: c_comm
  end function MPI_comm_f2c




end interface
end module
