program simple_solve
 
  use, intrinsic :: iso_c_binding
  use amgx_fortran
  
  implicit none

  type(c_ptr) :: cfg, res, solver, mode
  type(c_ptr) :: A, b, x, Ax


  ! Fichiers d'entree/sortie
  character(len=64), target :: cfg_file

  ! Parametre du systeme matriciel
  integer, parameter :: nx=5000, ny=5000
  integer :: size_x, size_y

  integer :: i, j, n, nnz, start_idx, nmtx
  integer, dimension(:), allocatable :: row_ptrs, col_indices
  double precision, dimension(:), allocatable :: values, rhs, sol


  ! Initialize
  call AMGX_initialize()
  call AMGX_initialize_plugins()

  ! Read config file
  cfg_file = "JACOBI.json"//C_NULL_CHAR
  call AMGX_config_create_from_file(cfg, c_loc(cfg_file))

  ! Create resources based on config
  call AMGX_resources_create_simple(res,cfg)

  ! Create solver object, A,x,b, set precision
  call AMGX_solver_create(solver, res, 8193, cfg)
  call AMGX_matrix_create(A,res,8193)
  call AMGX_vector_create(b,res,8193)
  call AMGX_vector_create(x,res,8193)

  ! Construct the linear system

  n = nx*ny
  allocate(row_ptrs(0:n))
  allocate(col_indices(0:6*n-1))
  allocate(values(0:6*n-1))
  nnz = 0

  do i = 0, n-1
    row_ptrs(i) = nnz
    if (i .gt. ny) then
      col_indices(nnz) = (i - ny)
      values(nnz) = -1.
      nnz = nnz + 1
    end if
    if (modulo(i,ny) .ne. 0) then
      col_indices(nnz) = (i - 1)
      values(nnz) = -1.
      nnz = nnz + 1
    end if
    col_indices(nnz) = i
    values(nnz) = 4.
    nnz = nnz + 1    
    if (modulo(i+1,ny) .eq. 0) then
      col_indices(nnz) = (i + 1)
      values(nnz) = -1.
      nnz = nnz + 1
    end if
    if (i/ny .ne. nx-1) then
      col_indices(nnz) = (i + ny)
      values(nnz) = -1.
      nnz = nnz + 1
    end if
  end do

  row_ptrs(n) = nnz

  call AMGX_matrix_upload_all(A, n, nnz, 1, 1, c_loc(row_ptrs), c_loc(col_indices), c_loc(values), c_null_ptr)

  deallocate(row_ptrs)
  deallocate(col_indices)
  deallocate(values)

  allocate(rhs(n), sol(n))
  rhs(:) = 1.
  sol(:) = 0.

  call AMGX_vector_bind(x, A);
  call AMGX_vector_bind(b, A);
  call AMGX_vector_upload(x, n, 1, c_loc(sol));
  call AMGX_vector_upload(b, n, 1, c_loc(rhs));

  ! Setup and Solve
  call AMGX_solver_setup(solver,A)
  call AMGX_solver_solve(solver, b, x)

  ! Recuperation du vecteur dans un tableau de data
  call AMGX_vector_download(x,c_loc(sol))

  ! Liberation de l'allocation memoire et des references
  call AMGX_matrix_destroy(A)
  call AMGX_vector_destroy(b)
  call AMGX_vector_destroy(x)
  call AMGX_solver_destroy(solver)
  call AMGX_resources_destroy(res)
  call AMGX_config_destroy(cfg)

end program simple_solve
