program vect

  use omp_lib

  implicit none

  integer, parameter  :: n=655360000

  integer :: i, ir, t1, t2

  real(kind=8), allocatable,dimension(:) :: a_vec, b_vec, c_vec, d_vec, e_vec
  !dir$ attributes align:64 ::a_vec,b_vec,c_vec,d_vec,e_vec
  
  real(kind=4) :: temps, t_cpu_0, t_cpu_1, t_cpu

  allocate(a_vec(n),b_vec(n),c_vec(n),d_vec(n),e_vec(n))

  !$omp parallel

  !$omp do schedule (static)
  do i=1,n
    a_vec(i)=0.
    c_vec(i)=sin(2.*i)
    b_vec(i)=cos(3.*i)
    d_vec(i)=sin(4.*i)
    e_vec(i)=cos(5.*i)
  enddo
  !$omp end do   
 
  !$omp barrier

  call cpu_time(t_cpu_0)
  call system_clock(count=t1, count_rate=ir)

  !$omp do schedule (static)
  do i=1,n
    a_vec(i)=b_vec(i)*c_vec(i) &
            +d_vec(i)*e_vec(i)
  enddo
  !$omp end do

  call cpu_time(t_cpu_1)
  call system_clock(count=t2, count_rate=ir)

  temps = real(t2-t1,kind=4)/real(ir,kind=4)
  t_cpu = t_cpu_1-t_cpu_0

  !$omp end parallel

  ! Impression du resultat
  print *, 'Temps CPU / system ', t_cpu, temps,' secs'
  print *, 'n :', n
  print *, 'Norme ||a|| = ', norm2(a_vec)

  deallocate(a_vec,b_vec,c_vec,d_vec,e_vec)


end program vect

