program prod_mat
  implicit none

  integer, parameter :: m=5000, n=5000
  real(kind=8), allocatable,dimension(:,:) :: a
  real(kind=8), allocatable,dimension(:,:) :: b
  real(kind=8), allocatable,dimension(:,:) :: c
  !dir$ attributes align:64 :: a,b,c
  real(kind=4) :: temps
  integer :: i,j,k,t1,t2, ir

  allocate(a(m,n),b(n,m),c(m,m))
  ! Intialisation des matrices A, B et C
  do j = 1, n
    do i = 1, m
      a(i,j) = real(i+j,kind=8)
    end do
  end do
  do j = 1, m
    do i = 1, n
      b(i,j) = real(i-j,kind=8)
    end do
  end do
  do j = 1, m
    do i = 1, m
      c(i,j) = 0.0
    end do
  end do

  ! Temps CPU de restitution initial
  call system_clock(count=t1, count_rate=ir)

  do i = 1, m
    do j = 1, n
      do k = 1, m
        c(i,j) = c(i,j) + a(i,k) * b(k,j)
      end do
    end do
  end do

  ! Temps CPU de restitution final
  call system_clock(count=t2, count_rate=ir)

  temps=real(t2-t1,kind=4)/real(ir,kind=4)

  deallocate(a,b,c)

end program prod_mat